package org.msh.tb.reports2.variables;

import org.jboss.seam.international.Messages;
import org.msh.reports.keys.Key;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.CaseDefinition;
import org.msh.tb.reports2.VariableImpl;

/**
 * Created by rmemoria on 6/9/17.
 */
public class BacteriologicResultVariable extends VariableImpl {

    public static final int KEY_XPERT = 1;
    public static final int KEY_SPUTUM = 2;

    public BacteriologicResultVariable() {
        super("bacresult", "manag.reportgen.var.bacresult", "caseDefinition");
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        def.select("(case when " +
                "exists (select * from examxpert where case_id=b.id and result=5) " +
                "then 1 else 2 end) bacres");

        def.addRestriction("caseDefinition = " + CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.ordinal());
    }

    @Override
    public String getDisplayText(Key key) {
        if (key.isNull()) {
            return "Unknown";
        }

        int val = (Integer)key.getValue();

        String msgKey = getKeylabel() + "." + val;

        return Messages.instance().get(msgKey);
    }
}
